unit CountMain;

// Wenn die Zhlerwerte in der Registry gespeichert werden sollen, dann fgen
// Sie hier das private Symbol "REG" fr den Compiler ein.
{$DEFINE REG}
// Anderenfalls werden die Zhlerwerte in einer Ini-Datei gespeichert.

interface

procedure IsapiAction(var s: String);

implementation

uses Windows, SysUtils, Classes, Graphics, IsapiHlp,
    {$IFDEF REG} Registry; {$ELSE} IniFiles; {$ENDIF}

{$R CTRBMP.RES}                      // hier sind die Style-Bitmaps gespeichert

const Digits = 5;                                     //Stellenzahl des Zhlers

{ --- XBitmap-Hilfsroutinen ------------------------------------------------- }

function PixToStr(a: Byte): String;  // konvertiert ein BMP-Byte in xbmp-String
var b,c: Byte; k: Integer;
begin
 b:=a;                                                    // lokale Kopie von a
 c:=0;                                                              // Ergebnis
 for k:=0 to 7 do begin                                      // 8 Bits spiegeln
  c:= c shl 1;
  c:= c or (b and 1);
  b:= b shr 1;
 end;
 Result:='0x' + IntToHex(c,2);
end;

function BmpToXBmp(Bmp: TBitmap): String;
var nZl, y, nSp, j: Integer;
    pLn : PByteArray;
    sErg: String;
begin
 sErg:='#define xBmp_width '+IntToStr(Bmp.Width)+#13#10+
       '#define xBmp_height '+IntToStr(Bmp.Height)+#13#10+
       'static char xBmp_bits[] = {'#13#10;                  // Header erzeugen
 nZl:=Bmp.Height-1;                          // Anzahl der Scanlinien im Bitmap
 nSp:=(Bmp.Width-1) div 8;                 // Anzahl der Bytes in der Scanlinie
 for y:=0 to nZl do begin                       // Ausgabe ber alle Scanlinien
  pLn:=Bmp.ScanLine[y];                              // Bitmap-Zeile einscannen
  for j:=0 to nSp do begin                                   // ber alle Bytes
   sErg:=sErg + PixToStr(pLn[j]);            // 1 Pixelbyte als String ausgeben
   if j<nSp then sErg:=sErg+', '
   else if y<nZl then sErg:=sErg+',' else sErg:=sErg+'};,';
  end;                                                        // naechstes Byte
 end;                                                     // naechste Scanlinie
 Result:=sErg;                                     // fertiger X-XBitmap-String
end;

{ --- private Hilfsroutinen ------------------------------------------------- }

function GetCountVal(Reference: String): Integer;       // Zhlerwert ermitteln
var nZ: Integer; {$IFDEF REG} Store: TRegistry {$ELSE} Store: TIniFile{$ENDIF};
begin
{$IFDEF REG}
 Store:=TRegistry.Create;
 Store.RootKey:=HKEY_LOCAL_MACHINE;
 nZ:=0;
 if Store.OpenKey('\SOFTWARE\WebCounter',true) then begin
  try nZ:=Store.ReadInteger(Reference) except nZ:=1 end;
  Store.WriteInteger(Reference,nZ+1);
 end;
{$ELSE}                                                    // Werte im Ini-File
 Store:=TIniFile.Create('Counter.ini');
 nZ:=Store.ReadInteger('Values',Reference,1);
 Store.WriteInteger('Values',Reference,nZ+1);
{$ENDIF}
 Store.Free;
 Result:=nZ;
end;

{ --- Hauptroutine -----------------------------------------------------------}

procedure IsapiAction(var s: String);
var BmpSrc, BmpDest: TBitmap;                       // Quell-Bild und Ziel-Bild
    ZhlValue, nZl, nSp, nDestL, nSrcL, j: Integer;
    BmpName, sQuery: String;
begin
 sQuery:=StrPas(ECBQueryString);
 j:=Pos('+',sQuery);                            // Trennzeichen Referenz+Bitmap
 if j>0 then begin                                // falls Bitmapname vorhanden
  BmpName:=UpperCase(Copy(sQuery,j+1,99));         // Stylename max. 99 Zeichen
  Delete(sQuery,j,99);
 end else BmpName:='DEFAULT';                          // wenn Bitmapname fehlt
 if Length(sQuery)=0 then sQuery:='Anonym';             // falls Referenz fehlt
 ZhlValue:=GetCountVal(sQuery);                        // Zhlerstand ermitteln

 BmpDest:=TBitmap.Create;                                // Ziel-Bitmap anlegen
 if BmpName<>'ERROR' then begin                 // Normalfall, wenn nicht Error
  BmpDest.Monochrome:=true;                              // wichtig fr XBitmap
  BmpDest.Canvas.CopyMode:=cmSrcInvert;
  BmpSrc:=TBitmap.Create;                               // Quell-Bitmap anlegen
  try
   BmpSrc.LoadFromResourceName(HInstance,BmpName)         // Stylevorlage laden
  except
   BmpSrc.LoadFromResourceName(HInstance,'DEFAULT')
  end;
  nZl:=BmpSrc.Height;                        // Anzahl der Scanlinien im Bitmap
  nSp:=BmpSrc.Width div 10;                              // Breite einer Stelle
  BmpDest.Height:=nZl;                                 // Hoehe des Ziel-Bitmap
  BmpDest.Width:=nSp*Digits;                          // Breite des Ziel-Bitmap
  for j:=0 to Digits-1 do begin                             // Ziffern zuordnen
   nDestL:=nSp*(Digits-(j+1));                    // linker Ziffernrand im Ziel
   nSrcL:= nSp*(ZhlValue mod 10);               // linker Ziffernrand in Quelle
   ZhlValue:=ZhlValue div 10;                     // letzte Stelle wegschneiden
   BmpDest.Canvas.CopyRect(Rect(nDestL,0,nDestL+nSp,nZl),BmpSrc.Canvas,Rect(nSrcL,0,nSrcL+nSp,nZl));
  end;
  BmpSrc.Free;                                        // Quell-Bitmap verwerfen
 end
 else begin                                                   // fr Error-Bild
  BmpDest.LoadFromResourceName(HInstance,'ERROR');       // Fehlerbild einlesen
 end;
 s:=BmpToXBmp(BmpDest);                            // Funktion aus Unit XBmpHlp
 BmpDest.Free;                                        // Ziel-Bitmap beseitigen
end;

end.
