unit CountMain;

// Wenn die Zhlerwerte in der Registry gespeichert werden sollen, dann fgen
// Sie hier das private Symbol "REG" fr den Compiler ein.
{$DEFINE REG}
// Anderenfalls werden die Zhlerwerte in einer Ini-Datei gespeichert.

interface

procedure IsapiAction(var s: String);

implementation

uses Windows, SysUtils, Classes, Graphics, IsapiHlp, GifImage,
    {$IFDEF REG} Registry; {$ELSE} IniFiles; {$ENDIF}

{$R CTRBMPG.RES}                  // hier sind die Standard-Bitmaps gespeichert

const Digits = 6;                                     //Stellenzahl des Zhlers

{ --- private Hilfsroutinen ------------------------------------------------- }

function GetCountVal(Reference: String): Integer;       // Zhlerwert ermitteln
var nZ: Integer; {$IFDEF REG} Store: TRegistry {$ELSE} Store: TIniFile{$ENDIF};
begin
{$IFDEF REG}
 Store:=TRegistry.Create;
 Store.RootKey:=HKEY_LOCAL_MACHINE;
 nZ:=0;
 if Store.OpenKey('\SOFTWARE\WebCounter',true) then begin
  try nZ:=Store.ReadInteger(Reference) except nZ:=1 end;
  Store.WriteInteger(Reference,nZ+1);
 end;
{$ELSE}                                                    // Werte im Ini-File
 Store:=TIniFile.Create('Counter.ini');
 nZ:=Store.ReadInteger('Values',Reference,1);
 Store.WriteInteger('Values',Reference,nZ+1);
{$ENDIF}
 Store.Free;
 Result:=nZ;
end;

{ --- Hauptroutine -----------------------------------------------------------}

procedure IsapiAction(var s: String);
var BmpSrc, BmpDest: TBitmap;
    ZhlValue, nZl, nSp, nDestL, nSrcL, j: Integer; nSize: Longint;
    BmpName, sQuery: String;
    MemStr: TMemoryStream;
    GifBild: TGifImage;
begin
 sQuery:=StrPas(ECBQueryString);
 j:=Pos('+',sQuery);                            // Trennzeichen Referenz+Bitmap
 if j>0 then begin                                // falls Bitmapname vorhanden
  BmpName:=UpperCase(Copy(sQuery,j+1,99));
  Delete(sQuery,j,99);
 end else BmpName:='DEFAULT';                          // wenn Bitmapname fehlt
 if Length(sQuery)=0 then sQuery:='Anonym';             // falls Referenz fehlt
 ZhlValue:=GetCountVal(sQuery);                        // Zhlerstand ermitteln

 BmpDest:=TBitmap.Create;                                // Ziel-Bitmap anlegen
 if BmpName<>'ERROR' then begin                 // Normalfall, wenn nicht Error
  BmpSrc:=TBitmap.Create;                               // Quell-Bitmap anlegen
  try
   BmpSrc.LoadFromResourceName(HInstance,BmpName)         // Stylevorlage laden
  except
   BmpSrc.LoadFromResourceName(HInstance,'DEFAULT')
  end;
  nZl:=BmpSrc.Height;                        // Anzahl der Scanlinien im Bitmap
  nSp:=BmpSrc.Width div 10;                              // Breite einer Stelle
  BmpDest.Height:=nZl;                                 // Hoehe des Ziel-Bitmap
  BmpDest.Width:=nSp*Digits;                          // Breite des Ziel-Bitmap
  BmpDest.Canvas.CopyMode:=cmSrcCopy;
  BmpDest.PixelFormat:=BmpSrc.PixelFormat;
  for j:=0 to Digits-1 do begin                             // Ziffern zuordnen
   nDestL:=nSp*(Digits-(j+1));                    // linker Ziffernrand im Ziel
   nSrcL:= nSp*(ZhlValue mod 10);               // linker Ziffernrand in Quelle
   ZhlValue:=ZhlValue div 10;                     // letzte Stelle wegschneiden
   BmpDest.Canvas.CopyRect(Rect(nDestL,0,nDestL+nSp,nZl),BmpSrc.Canvas,Rect(nSrcL,0,nSrcL+nSp,nZl));
  end;
  BmpSrc.Free;                                        // Quell-Bitmap verwerfen
 end
 else begin                                                   // fr Error-Bild
  BmpDest.LoadFromResourceName(HInstance,'ERROR');       // Fehlerbild einlesen
 end;
 MemStr:=TMemoryStream.Create;
 GifBild:=TGifImage.Create;
 GifBild.Assign(BmpDest);
 GifBild.SaveToStream(MemStr);
 GifBild.Free;
 BmpDest.Free;                                        // Ziel-Bitmap beseitigen
 nSize:=MemStr.Size;
 MemStr.Position:=0;
 SetLength(s,nSize);
 MemStr.Read(s[1],nSize);
 MemStr.Free;
end;

end.
