unit UnitFmMl;

// Wenn die konstanten Mailparameter aus der Registry entnommen werden sollen,
// dann fgen Sie hier das private Symbol "REG" fr den Compiler ein.
// {$DEFINE REG}
// Anderenfalls werden die Mailparameter aus einer Ini-Datei entnommen.

interface

procedure IsapiAction(var s: String);

implementation

uses SysUtils, Classes,{$IFDEF REG} Windows, Registry{$ELSE} IniFiles{$ENDIF},
     IsapiHlp, SMTPSend;

{$IFNDEF REG} const ParamFile='FormMail.ini'; {$ENDIF}

{ --- Hilfsroutinen ---------------- }

procedure GetConstantMailParams(var SMTPStruc: TSMTPStruct); {feste Mailparameter ermitteln}
var Store: {$IFDEF REG} TRegistry {$ELSE} TIniFile{$ENDIF};
begin
 SMTPStruc.Server:=''; SMTPStruc.From:=''; SMTPStruc.Sender:='';
{$IFDEF REG}                                            {Werte in der Registry}
 Store:=TRegistry.Create;
 Store.RootKey:=HKEY_LOCAL_MACHINE;
 if Store.OpenKey('\SOFTWARE\FormMail',true) then try
  SMTPStruc.Server:=Store.ReadString('SMTPServer');
  SMTPStruc.From:=Store.ReadString('MailFrom');
  SMTPStruc.Sender:=Store.ReadString('Sender');
{$ELSE}                                                     {Werte in Ini-File}
 Store:=TIniFile.Create(ParamFile);
 try
  SMTPStruc.Server:=Store.ReadString('SMTP','SMTPServer','');
  SMTPStruc.From:=Store.ReadString('SMTP','MailFrom','');
  SMTPStruc.Sender:=Store.ReadString('SMTP','Sender','');
{$ENDIF}
 finally Store.Free end;
end;

procedure GenerateOK(Liste: TStringList; var s: String);
var i: Integer;
begin
 s:=HtmlHeader('Bestaetigung','FFFFFF','');          {Antwortseite generieren}
 s:=s+'<H2 ALIGN="CENTER">Best&auml;tigung</H2><HR>';
 s:=s+'Wir best&auml;tigen den Eingang folgender Daten:';
 s:=s+'<UL>';
 for i:=0 to Liste.Count-1 do s:=s+'<LI>'+Liste.Strings[i];
 s:=s+'</UL>';
 s:=s+'<HR><P><SMALL>'+FormatDateTime('yyyy-mm-dd, hh:nn:ss',Now())+'</SMALL>'
     +HtmlFooter;
end;

procedure GenerateErr(ErrNo: Integer; var s: String);
begin
  s:=HtmlHeader('Fehlerreport','FFFFFF','');
  s:=s+'<H2 ALIGN="CENTER">Fehlerreport</H2><HR>';
  s:=s+'Bei der bermittlung Ihrer Daten ist ein Fehler aufgetreten! ';
  s:=s+'Die Daten wurden <B>nicht</B> weitergeleitet.';
  s:=s+'<P>Der Fehler lautet: ';
  case ErrNo of
   SMTP_TRANSERR: s:=s+'&Uuml;bertragungsfehler';
   SMTP_NOSERVER: s:=s+'Mailserver nicht bereit';
   SMTP_NONET   : s:=s+'keine Netzwerkverbindung';
   SMTP_NOPARAMS: s:=s+'fehlende Sendeparameter';
  end;
  s:=s+'<P>Wenden Sie sich bitte an den Webmaster.';
  s:=s+'<HR><P><SMALL>'+FormatDateTime('yy-mm-dd, hh:nn:ss',Now())+'</SMALL>'+HtmlFooter;
end;

{ --- Hauptroutine ----------------- }

procedure IsapiAction(var s: String);
var SMTPDaten: TSMTPStruct; nErg: Integer;
begin
 {e-Mail-Parameter vorbereiten, Daten gem Deklaration in Unit SMTPSend.PAS  }
 GetConstantMailParams(SMTPDaten);   {feste Sendeparameter fr e-Mail einholen}
 SMTPDaten.Content:=TStringList.Create;
 GetContentData(SMTPDaten.Content); {Formulareingaben abholen und in die Liste}
 SMTPDaten.Receiver:=SMTPDaten.Content.Values['MailTo'];  {HIDDEN-Formularfeld}
 SMTPDaten.Subject:=SMTPDaten.Content.Values['Subject'];  {HIDDEN-Formularfeld}
 SMTPDaten.Content.Delete(SMTPDaten.Content.IndexOfName('MailTo'));
 SMTPDaten.Content.Delete(SMTPDaten.Content.IndexOfName('Subject'));
 nErg:=SMTPSendMail(SMTPDaten);  {e-Mail senden mit Funktion aus Unit SMTPSend}
 if nErg=SMTP_MAILOK then GenerateOK(SMTPDaten.Content, s)  {Besttigungsseite}
 else GenerateErr(nErg, s);                    {Fehlermeldungsseite generieren}
 SMTPDaten.Content.Free;
end;

end.
